/*
 * Decompiled with CFR 0.152.
 */
package neoforge.com.cursee.more_bows_and_arrows.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CommonEffectsUtil {
    public static void lightingCausedByPlayer(Player player, BlockPos blockPos) {
        Level level = player.level();
        LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level);
        if (bolt == null) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            bolt.setCause(serverPlayer);
        }
        bolt.moveTo(Vec3.atBottomCenterOf((Vec3i)blockPos));
        level.addFreshEntity((Entity)bolt);
    }

    public static void lightOrIgniteBlock(BlockHitResult result, Level level) {
        BlockPos blockPos = result.getBlockPos();
        if (!level.getBlockState(blockPos).hasProperty((Property)BlockStateProperties.LIT)) {
            BlockPos relativePosition = blockPos.relative(result.getDirection());
            if (level.isEmptyBlock(relativePosition)) {
                level.setBlockAndUpdate(relativePosition, BaseFireBlock.getState((BlockGetter)level, (BlockPos)relativePosition));
            }
        } else {
            level.setBlock(blockPos, (BlockState)level.getBlockState(blockPos).setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }
}

